// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     skia/public/interfaces/bitmap.mojom
//

package org.chromium.mojom.skia;

public final class Bitmap extends org.chromium.mojo.bindings.Struct {

    private static final int STRUCT_SIZE = 40;
    private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(40, 0)};
    private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

    public int colorType;
    public int alphaType;
    public int profileType;
    public int width;
    public int height;
    public byte[] pixelData;

    private Bitmap(int version) {
        super(STRUCT_SIZE, version);
    }

    public Bitmap() {
        this(0);
    }

    public static Bitmap deserialize(org.chromium.mojo.bindings.Message message) {
        return decode(new org.chromium.mojo.bindings.Decoder(message));
    }

    @SuppressWarnings("unchecked")
    public static Bitmap decode(org.chromium.mojo.bindings.Decoder decoder0) {
        if (decoder0 == null) {
            return null;
        }
        org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
        Bitmap result = new Bitmap(mainDataHeader.elementsOrVersion);
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.colorType = decoder0.readInt(8);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.alphaType = decoder0.readInt(12);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.profileType = decoder0.readInt(16);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.width = decoder0.readInt(20);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.height = decoder0.readInt(24);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.pixelData = decoder0.readBytes(32, org.chromium.mojo.bindings.BindingsHelper.NOTHING_NULLABLE, org.chromium.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
        }
        return result;
    }

    @SuppressWarnings("unchecked")
    @Override
    protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
        org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        encoder0.encode(colorType, 8);
        encoder0.encode(alphaType, 12);
        encoder0.encode(profileType, 16);
        encoder0.encode(width, 20);
        encoder0.encode(height, 24);
        encoder0.encode(pixelData, 32, org.chromium.mojo.bindings.BindingsHelper.NOTHING_NULLABLE, org.chromium.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
    }

    /**
     * @see Object#equals(Object)
     */
    @Override
    public boolean equals(Object object) {
        if (object == this)
            return true;
        if (object == null)
            return false;
        if (getClass() != object.getClass())
            return false;
        Bitmap other = (Bitmap) object;
        if (this.colorType != other.colorType)
            return false;
        if (this.alphaType != other.alphaType)
            return false;
        if (this.profileType != other.profileType)
            return false;
        if (this.width != other.width)
            return false;
        if (this.height != other.height)
            return false;
        if (!java.util.Arrays.equals(this.pixelData, other.pixelData))
            return false;
        return true;
    }

    /**
     * @see Object#hashCode()
     */
    @Override
    public int hashCode() {
        final int prime = 31;
        int result = prime + getClass().hashCode();
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(colorType);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(alphaType);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(profileType);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(width);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(height);
        result = prime * result + java.util.Arrays.hashCode(pixelData);
        return result;
    }
}

